/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class QDTabUI
extends BasicTabbedPaneUI {
    private int tabEdgeLength = 8;
    private Polygon shape;
    private GradientPaint gradientShadow = null;
    private GradientPaint gradientGray = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new QDTabUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets.right = this.tabEdgeLength;
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        Rectangle rectangle4 = new Rectangle(rectangle);
        rectangle4.width -= this.tabEdgeLength;
        super.layoutLabel(n, fontMetrics, n2, string, icon, rectangle4, rectangle2, rectangle3, bl);
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        super.paintTabArea(graphics, n, n2);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.gradientShadow == null) {
            this.gradientShadow = new GradientPaint(n3, n4, QDStdUI.getButtonDark().brighter(), n3, n4 + n6, QDStdUI.getButtonDark().darker());
            this.gradientGray = new GradientPaint(n3, n4, QDStdUI.getButtonLight().darker(), n3, n4 + n6, QDStdUI.getButtonDark());
        }
        int[] nArray = null;
        int[] nArray2 = null;
        switch (n) {
            case 2: {
                nArray = new int[]{n3, n3, n3 + n5, n3 + n5, n3};
                nArray2 = new int[]{n4, n4 + n6 - 3, n4 + n6 - 3, n4, n4};
                break;
            }
            case 4: {
                nArray = new int[]{n3, n3, n3 + n5 - 2, n3 + n5 - 2, n3};
                nArray2 = new int[]{n4, n4 + n6 - 3, n4 + n6 - 3, n4, n4};
                break;
            }
            case 3: {
                nArray = new int[]{n3, n3, n3 + 3, n3 + n5 - this.tabEdgeLength - 6, n3 + n5 - this.tabEdgeLength - 2, n3 + n5 - this.tabEdgeLength, n3 + n5 - 3, n3};
                nArray2 = new int[]{n4, n4 + n6 - 3, n4 + n6, n4 + n6, n4 + n6 - 1, n4 + n6 - 3, n4, n4};
                break;
            }
            default: {
                nArray = new int[]{n3, n3, n3 + 3, n3 + n5 - this.tabEdgeLength - 6, n3 + n5 - this.tabEdgeLength - 2, n3 + n5 - this.tabEdgeLength, n3 + n5, n3};
                nArray2 = new int[]{n4 + n6, n4 + 3, n4, n4, n4 + 1, n4 + 3, n4 + n6, n4 + n6};
            }
        }
        this.shape = new Polygon(nArray, nArray2, nArray.length);
        if (this.runCount > 1) {
            graphics2D.setColor(new Color(0, 0, 0, 50 + 10 * (this.getRunForTab(this.tabPane.getTabCount(), n2) - 1)));
            graphics2D.fill(this.shape);
        }
        if (bl) {
            graphics2D.setPaint(this.gradientGray);
            graphics2D.fill(this.shape);
        } else {
            graphics2D.setPaint(this.gradientShadow);
            graphics2D.fill(this.shape);
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
            Color color = Color.white;
            if (bl) {
                color = QDStdUI.getActionForeground();
            }
            graphics.setColor(color);
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            graphics.setColor(QDStdUI.getButtonLight());
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(QDStdUI.getButtonLight().darker());
            graphics.drawString(string, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        return 8 + this.tabEdgeLength + super.calculateTabWidth(n, n2, fontMetrics);
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        if (n == 2 || n == 4) {
            return super.calculateTabHeight(n, n2, n3);
        }
        return 2 + super.calculateTabHeight(n, n2, n3);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl) {
            graphics2D.setColor(QDStdUI.getActionForeground());
            graphics2D.draw(this.shape);
        } else {
            graphics2D.setColor(QDStdUI.getButtonLight());
            graphics2D.draw(this.shape);
        }
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    public void paintContentBorder(Graphics graphics, int n, int n2) {
        boolean bl = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(n);
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                if (bl) {
                    n5 -= insets2.right;
                }
                n7 -= n5 - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                if (!bl) break;
                n7 += insets2.left;
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                if (!bl) break;
                n8 += insets2.top;
                break;
            }
            default: {
                n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                if (bl) {
                    n6 -= insets2.bottom;
                }
                n8 -= n6 - insets.top;
            }
        }
        graphics.setColor(QDStdUI.getActionBackground());
        graphics.fillRect(n5, n6, n7, n8);
    }
}

